function sendLocationToMap(lat, lng) {
    const frame = document.getElementById("rt-frame");
    frame.contentWindow.postMessage({
        type: "USER_LOCATION",
        latitude: lat,
        longitude: lng
    }, "*");
}

function requestMapLocation() {
    if (navigator.geolocation) {
        navigator.geolocation.getCurrentPosition(pos => {
            sendLocationToMap(pos.coords.latitude, pos.coords.longitude);
        });
    }
}

window.onload = requestMapLocation;
